<?php
/**
 * Payment Form Template
 *
 * @package Spaceremit_WooCommerce
 * @var WC_Order $order
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$order = wc_get_order( $order_id );

if ( ! $order ) {
	return;
}

// إذا جاء كود الدفع من Spaceremit عبر GET (إعادة توجيه من مزود الدفع)، تحقق منه ثم حوّل لصفحة الاستلام.
if ( isset( $_GET['SP_payment_code'] ) ) {
	$payment_code = sanitize_text_field( wp_unslash( $_GET['SP_payment_code'] ) );
	
	// Get gateway instance (create if not available)
	if ( ! isset( $gateway ) || ! $gateway instanceof WC_Spaceremit_Gateway ) {
		$gateway = new WC_Spaceremit_Gateway();
	}
	
	// Prevent duplicate processing (lock)
	$processed_flag = $order->get_meta( '_spaceremit_processed' );
	if ( 'yes' === $processed_flag ) {
		wp_safe_redirect( $order->get_checkout_order_received_url() );
		exit;
	}
	if ( 'processing' === $processed_flag ) {
		wp_safe_redirect( $order->get_checkout_order_received_url() );
		exit;
	}
	$order->update_meta_data( '_spaceremit_processed', 'processing' );
	$order->save_meta_data();

	$verification = $gateway->verify_payment( $payment_code );

	if ( is_wp_error( $verification ) ) {
		wc_add_notice( $verification->get_error_message(), 'error' );
	} else {
		// Prevent duplicate processing
		if ( $order->get_meta( '_spaceremit_processed' ) === 'yes' ) {
			wp_safe_redirect( $order->get_checkout_order_received_url() );
			exit;
		}

		$payment_data = $verification['data'];
		$payment_id   = $payment_data['id'] ?? '';
		$status_tag   = $payment_data['status_tag'] ?? '';
		$status       = $payment_data['status'] ?? '';

		$order->update_meta_data( '_spaceremit_payment_id', $payment_id );
		$order->update_meta_data( '_spaceremit_payment_code', $payment_code );
		$order->update_meta_data( '_spaceremit_payment_status', $status );
		$order->update_meta_data( '_spaceremit_payment_status_tag', $status_tag );

		// تطبيع المبلغ ليطابق الطلب (وتجاهل العمولة).
		$order_amount   = (float) $order->get_total();
		$payment_amount = isset( $payment_data['total_amount'] ) ? (float) $payment_data['total_amount'] : $order_amount;
		$payment_data['total_amount'] = $order_amount;
		// Ignore فرق المبلغ بصمت ونستخدم مبلغ الطلب فقط.

		// Always keep order Pending for manual review.
		spaceremit_set_status_silent( $order, 'pending', false );
		spaceremit_add_note_once(
			$order,
			'spaceremit_pending',
			__( 'لديك عملية شراء جديدة قيد المراجعة، قام عميلك بارسال طلب دفع وهو بانتظار التأكيد من قبل الوكيل. الوقت المتوقع لتاكيد الطلب 0 - 12 ساعة', 'spaceremit-woocommerce' )
		);

		// Clean default WC status-change notes
		spaceremit_remove_status_notes( $order );

		$order->update_meta_data( '_spaceremit_processed', 'yes' );
		$order->save();
		
		// Get the order received URL using WooCommerce's method
		$thank_you_url = $order->get_checkout_order_received_url();
		
		// Ensure we have a valid URL
		if ( empty( $thank_you_url ) ) {
			// Fallback: construct manually using WooCommerce settings
			$checkout_url = wc_get_checkout_url();
			$order_received_endpoint = get_option( 'woocommerce_checkout_order_received_endpoint', 'order-received' );
			$thank_you_url = wc_get_endpoint_url( $order_received_endpoint, $order_id, $checkout_url );
			$thank_you_url = add_query_arg( 'key', $order->get_order_key(), $thank_you_url );
		}
		
		wp_safe_redirect( $thank_you_url );
		exit;
	}
}

// If order already paid/processed, redirect to order received page instead of showing pay form.
// إذا كان الطلب لا يحتاج دفع (مدفوع أو في حالة معالجة/قيد الانتظار)، أعد التوجيه لصفحة الاستلام.
if ( ! $order->needs_payment() ) {
	wp_safe_redirect( $order->get_checkout_order_received_url() );
	exit;
}

// Get customer information.
$fullname = trim( $order->get_billing_first_name() . ' ' . $order->get_billing_last_name() );
$email    = $order->get_billing_email();
$phone    = $order->get_billing_phone();

// Get order details.
$amount   = $order->get_total();
$currency = $order->get_currency();
?>

<div class="spaceremit-payment-container">
	<div class="spaceremit-payment-info">
		<h3><?php esc_html_e( 'تفاصيل الطلب', 'spaceremit-woocommerce' ); ?></h3>
		<p>
			<strong><?php esc_html_e( 'رقم الطلب:', 'spaceremit-woocommerce' ); ?></strong> 
			<?php echo esc_html( $order->get_order_number() ); ?>
		</p>
		<p>
			<strong><?php esc_html_e( 'المبلغ:', 'spaceremit-woocommerce' ); ?></strong> 
			<?php echo wp_kses_post( $order->get_formatted_order_total() ); ?>
		</p>
	</div>

	<div class="spaceremit-notice" style="display: none;">
		<p class="notice-message"></p>
	</div>

	<div class="spaceremit-payment-form-wrapper">
		<form id="spaceremit-form" class="spaceremit-payment-form">
			<!-- Hidden input fields for amount and currency -->
			<input type="hidden" name="amount" value="<?php echo esc_attr( $amount ); ?>">
			<input type="hidden" name="currency" value="<?php echo esc_attr( $currency ); ?>">
			
			<!-- Hidden input fields for buyer information -->
			<input type="hidden" name="fullname" value="<?php echo esc_attr( $fullname ); ?>">
			<input type="hidden" name="email" value="<?php echo esc_attr( $email ); ?>">
			<input type="hidden" name="phone" value="<?php echo esc_attr( $phone ); ?>">
			<input type="hidden" name="notes" value="<?php echo esc_attr( $order->get_order_number() ); ?>">
			
			<!-- Local methods is always enabled (required) - hidden radio button for Spaceremit JS -->
			<!-- Spaceremit library checks for checked radio button, so we use hidden radio instead of hidden input -->
			<input type="radio" name="sp-pay-type-radio" value="local-methods-pay" id="sp_local_methods_radio" checked style="position: absolute; opacity: 0; pointer-events: none; width: 0; height: 0;">
			
			<!-- Container for displaying local payment methods -->
			<div id="spaceremit-local-methods-pay"></div>
			
			<!-- Button to submit the form -->
			<div class="spaceremit-submit-wrapper">
				<button type="submit" class="button spaceremit-submit-button">
					<?php esc_html_e( 'الدفع الآن', 'spaceremit-woocommerce' ); ?>
				</button>
			</div>
		</form>
	</div>

	<div class="spaceremit-loading" style="display: none;">
		<p><?php esc_html_e( 'جاري معالجة الدفع...', 'spaceremit-woocommerce' ); ?></p>
	</div>

	<div class="spaceremit-error" style="display: none;">
		<p class="error-message"></p>
	</div>
</div>

