/* global wc, spaceremitBlocksData */
( function() {
	const registry = window.wc && window.wc.wcBlocksRegistry;
	const element = window.wp && window.wp.element;

	if ( ! registry || ! registry.registerPaymentMethod || ! element ) {
		return;
	}

	const { createElement, Fragment } = element;

	const label = ( spaceremitBlocksData && spaceremitBlocksData.title ) || 'Spaceremit';
	const description = ( spaceremitBlocksData && spaceremitBlocksData.description ) || '';
	const supports = ( spaceremitBlocksData && spaceremitBlocksData.supports ) || [ 'products' ];

	// Use actual React elements (not functions) to satisfy Blocks registry.
	const emptyElement = createElement( Fragment, null );

	registry.registerPaymentMethod( {
		name: 'spaceremit',
		label,
		ariaLabel: label,
		content: emptyElement,
		edit: emptyElement,
		canMakePayment: () => true,
		supports: {
			features: supports,
		},
		description,
	} );
} )();

